//----------------------------------------------------------------------------//
//- CaoRegistry.pas ----------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Klasse, die alle Registryzugriffe kapselt                                  //
//----------------------------------------------------------------------------//

unit CaoRegistry;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Registry;

//------------------------------------------------------------------------------

Type
  TCaoRegistry = class(TObject)

  //----------------------------------------------------------------------------

  public
    constructor Create;    reintroduce;
    destructor  Destroy;   reintroduce;
    procedure   WriteAnzFehlendeEtiketten(iFehlendeEtiketten: Integer);
    function    ReadAnzFehlendeEtiketten: Integer;
    procedure   WriteInitialenDrucken    (fInitialenDrucken : Boolean);
    function    ReadInitialenDrucken    : Boolean;
    procedure   WritePassword            (sPasswort         : string);
    function    ReadPassword            : string;

  //----------------------------------------------------------------------------

  private
    m_obRegistry: TRegistry;

  //----------------------------------------------------------------------------

  end; // TCaoRegistry

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

uses
  Windows, CamConst;

//------------------------------------------------------------------------------

constructor TCaoRegistry.Create;
begin
  inherited Create;
  m_obRegistry         := TRegistry.Create;
  // Die Einstellungen sollen im Allgemeinen Teil der Registry abgelegt werden
  m_obRegistry.RootKey := HKEY_LOCAL_MACHINE;
end; // TCaoRegistry.Create

//------------------------------------------------------------------------------

destructor TCaoRegistry.Destroy;
begin
  m_obRegistry.Free;
  inherited Destroy;
end; // TCaoRegistry.Destroy

//------------------------------------------------------------------------------

function TCaoRegistry.ReadAnzFehlendeEtiketten: Integer;
(*
  Lesen der Anzahl fehlender Etiketten aus der Registry
*)
begin
  // Den Schlssel ffnen
  m_obRegistry.OpenKey(c_sStandardKey + '\' + c_sFirmaKey +
                       '\' + c_sProgrammKey, True);
  // Existiert der Eintrag bereits, wird dieser gelesen
  if m_obRegistry.ValueExists(c_sEintragFehlendeEtiketten) then begin
    Result := m_obRegistry.ReadInteger(c_sEintragFehlendeEtiketten);
  end // if
  // Existiert der Eintrag noch nicht, wird er angelegt
  else begin
    Result := 0;
    m_obRegistry.WriteInteger(c_sEintragFehlendeEtiketten, 0);
  end; // else
  m_obRegistry.CloseKey;
end; // TCaoRegistry.ReadAnzFehlendeEtiketten

//------------------------------------------------------------------------------

procedure TCaoRegistry.WriteAnzFehlendeEtiketten(iFehlendeEtiketten: Integer);
(*
  Schreiben der Anzahl fehlender Etiketten in die Registry
*)
begin
  // ffnen des Registry-Schlssels
  // Wurde der Schlssel noch nicht erstellt, so wird das hier auch gleich
  // erledigt
  m_obRegistry.OpenKey(c_sStandardKey + '\' + c_sFirmaKey +
                       '\' + c_sProgrammKey, True);
  m_obRegistry.WriteInteger(c_sEintragFehlendeEtiketten, iFehlendeEtiketten);
  m_obRegistry.CloseKey;
end; // TCaoRegistry.WriteAnzFehlendeEtiketten

//------------------------------------------------------------------------------

function TCaoRegistry.ReadInitialenDrucken: Boolean;
(*
  Lesen der Initialen-Drucken Einstellung aus der Registry
*)
begin
  m_obRegistry.OpenKey(c_sStandardKey + '\' + c_sFirmaKey +
                       '\' + c_sProgrammKey, True);
  // Existiert der Eintrag bereits, wird dieser gelesen
  if m_obRegistry.ValueExists(c_sEintragInitialenDrucken) then begin
    Result := m_obRegistry.ReadBool(c_sEintragInitialenDrucken);
  end // if
  // Existiert der Eintrag noch nicht, wird er angelegt
  else begin
    Result := True;
    m_obRegistry.WriteBool(c_sEintragInitialenDrucken, True);
  end; // else
  m_obRegistry.CloseKey;
end; // TCaoRegistry.ReadInitialenDrucken

//------------------------------------------------------------------------------

procedure TCaoRegistry.WriteInitialenDrucken(fInitialenDrucken: Boolean);
(*
  Schreiben der Initialen-Drucken Einstellung in die Registry
*)
begin
  // ffnen des Registry-Schlssels
  // Wurde der Schlssel noch nicht erstellt, so wird das hier auch gleich
  // erledigt
  m_obRegistry.OpenKey(c_sStandardKey + '\' + c_sFirmaKey +
                       '\' + c_sProgrammKey, True);
  m_obRegistry.WriteBool(c_sEintragInitialenDrucken, fInitialenDrucken);
  m_obRegistry.CloseKey;
end; // TCaoRegistry.WriteInitialenDrucken

//------------------------------------------------------------------------------

function TCaoRegistry.ReadPassword: string;
(*
  Lesen des Passwortes aus der Registry
*)
begin
  m_obRegistry.OpenKey(c_sStandardKey + '\' + c_sFirmaKey +
                       '\' + c_sProgrammKey, True);
  // Existiert der Eintrag bereits, wird dieser gelesen
  if m_obRegistry.ValueExists(c_sEintragPassword) then begin
    Result := m_obRegistry.ReadString(c_sEintragPassword);
  end // if
  // Existiert der Eintrag noch nicht, wird er angelegt
  else begin
    Result := '123456';
    m_obRegistry.WriteString(c_sEintragPassword, '123456');
  end; // else
  m_obRegistry.CloseKey;
end; // TCaoRegistry.ReadPassword

//------------------------------------------------------------------------------

procedure TCaoRegistry.WritePassword(sPasswort: string);
(*
  Schreiben des Passwortes in die Registry
*)
begin
  // ffnen des Registry-Schlssels
  // Wurde der Schlssel noch nicht erstellt, so wird das hier auch gleich
  // erledigt
  m_obRegistry.OpenKey(c_sStandardKey + '\' + c_sFirmaKey +
                       '\' + c_sProgrammKey, True);
  m_obRegistry.WriteString(c_sEintragPassword, sPasswort);
  m_obRegistry.CloseKey;
end; // TCaoRegistry.WritePassword

//------------------------------------------------------------------------------

end. // CaoRegistry
